/**
 * Aptana Studio
 * Copyright (c) 2005-2011 by Appcelerator, Inc. All Rights Reserved.
 * Licensed under the terms of the GNU Public License (GPL) v3 (with exceptions).
 * Please see the license.html included with this distribution for details.
 * Any modifications to this file must keep this entire header intact.
 */
package com.aptana.editor.svg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;

import com.aptana.editor.common.CommonDocumentProvider;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;

public class SVGDocumentProvider extends CommonDocumentProvider
{
	/*
	 * (non-Javadoc)
	 * @see com.aptana.editor.common.CommonDocumentProvider#connect(java.lang.Object)
	 */
	@Override
	public void connect(Object element) throws CoreException
	{
		super.connect(element);

		IDocument document = getDocument(element);

		if (document != null)
		{
			CompositePartitionScanner partitionScanner = new CompositePartitionScanner( //
				SVGSourceConfiguration.getDefault().createSubPartitionScanner(), //
				new NullSubPartitionScanner(), //
				new NullPartitionerSwitchStrategy() //
			);
			IDocumentPartitioner partitioner = new ExtendedFastPartitioner( //
				partitionScanner, //
				SVGSourceConfiguration.getDefault().getContentTypes() //
			);

			partitionScanner.setPartitioner((IExtendedPartitioner) partitioner);
			partitioner.connect(document);
			document.setDocumentPartitioner(partitioner);

			CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration( //
				document, //
				SVGSourceConfiguration.getDefault() //
			);
		}
	}

	/*
	 * (non-Javadoc)
	 * @see com.aptana.editor.common.CommonDocumentProvider#getDefaultContentType(java.lang.String)
	 */
	protected String getDefaultContentType(String filename)
	{
		return ISVGConstants.CONTENT_TYPE_SVG;
	}
}
